/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapgen.noise;

import java.util.Random;

public class PerlinNoiseGenerator {
    private Random random;

    public PerlinNoiseGenerator(Random random) {
        this.random = random;
    }

    public float[][] generateWhiteNoise(int width, int height) {
        float[][] noise = new float[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                noise[x][y] = this.random.nextFloat();
            }
        }
        return noise;
    }

    public float interpolate(float x0, float x1, float alpha) {
        return x0 * (1.0f - alpha) + alpha * x1;
    }

    public float[][] generateSmoothNoise(float[][] baseNoise, int octave) {
        int width = baseNoise.length;
        int height = baseNoise[0].length;
        float[][] smoothNoise = new float[width][height];
        int samplePeriod = 1 << octave;
        float sampleFrequency = 1.0f / (float)samplePeriod;
        for (int i = 0; i < width; ++i) {
            int sample_i0 = i / samplePeriod * samplePeriod;
            int sample_i1 = (sample_i0 + samplePeriod) % width;
            float horizontal_blend = (float)(i - sample_i0) * sampleFrequency;
            for (int j = 0; j < height; ++j) {
                int sample_j0 = j / samplePeriod * samplePeriod;
                int sample_j1 = (sample_j0 + samplePeriod) % height;
                float vertical_blend = (float)(j - sample_j0) * sampleFrequency;
                float top = this.interpolate(baseNoise[sample_i0][sample_j0], baseNoise[sample_i1][sample_j0], horizontal_blend);
                float bottom = this.interpolate(baseNoise[sample_i0][sample_j1], baseNoise[sample_i1][sample_j1], horizontal_blend);
                smoothNoise[i][j] = this.interpolate(top, bottom, vertical_blend);
            }
        }
        return smoothNoise;
    }

    public float[][] generatePerlinNoise(float[][] baseNoise, int octaveCount) {
        int width = baseNoise.length;
        int height = baseNoise[0].length;
        float[][][] smoothNoise = new float[octaveCount][][];
        float persistance = 0.7f;
        for (int i = 0; i < octaveCount; ++i) {
            smoothNoise[i] = this.generateSmoothNoise(baseNoise, i);
        }
        float[][] perlinNoise = new float[width][height];
        float amplitude = 1.0f;
        float totalAmplitude = 0.0f;
        for (int octave = octaveCount - 1; octave >= 0; --octave) {
            totalAmplitude += (amplitude *= persistance);
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    float[] fArray = perlinNoise[i];
                    int n = j;
                    fArray[n] = fArray[n] + smoothNoise[octave][i][j] * amplitude;
                }
            }
        }
        for (int i = 0; i < width; ++i) {
            int j = 0;
            while (j < height) {
                float[] fArray = perlinNoise[i];
                int n = j++;
                fArray[n] = fArray[n] / totalAmplitude;
            }
        }
        return perlinNoise;
    }

    public float[][] generatePerlinNoise(int width, int height, int octaveCount) {
        float[][] baseNoise = this.generateWhiteNoise(width, height);
        return this.generatePerlinNoise(baseNoise, octaveCount);
    }

    public byte[] generateHeightMap(int width, int height, int min, int max, int octaveCount) {
        float[][] baseNoise = this.generateWhiteNoise(width, height);
        float[][] noise = this.generatePerlinNoise(baseNoise, octaveCount);
        byte[] bytes = new byte[baseNoise.length * baseNoise[0].length];
        int idx = 0;
        int range = max - min;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bytes[idx++] = (byte)(noise[x][y] * (float)range + (float)min);
            }
        }
        return bytes;
    }
}

